/*
 *  linux/arch/arm/mach-uniphier/include/mach/lpd-regs.h
 *
 *  Copyright (C) 2012 Panasonic Corporation
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 */

#ifndef _ASM_ARCH_LPD_H
#define _ASM_ARCH_LPD_H

#ifdef CONFIG_MACH_MN2WS0220_REF
#define LPD_BASE	(0x5BC00000)	/* P.A. */


#define LPD_C_OFFSET  0x00200000
#define LPD_D_OFFSET  0x00001000


#define LPD_C_BASE(a)			(LPD_BASE + LPD_C_OFFSET * (a))

#define LPD_M_BASE(a)			(LPD_C_BASE(a) + 0x00001000)
#define LPD_D_BASE(a, b)		(LPD_C_BASE(a) + 0x00004000 + LPD_D_OFFSET * (b))


#define LPD_DEN_A(a, b, c)		(LPD_D_BASE(a, b) + 0x08 + 0xF8 * (c))


#define LPD_BTI(a, b, c)		(LPD_M_BASE(a) + 0x200 + 0x60 * (b) + 0x4 * (1 - (c)))


#define LPD_CTLTI(a, b, c)		(LPD_M_BASE(a) + 0x240 + 0x60 * (b) + 0x4 * (1 - (c)))


#define LPD_WTI(a, b, c, d)		(LPD_M_BASE(a) + 0x00 + 0x100 * (b) + 0x20 * (1 - (c)) + 0x4 * (d))
#define LPD_WTI_D(a, b, c)		(LPD_M_BASE(a) + 0x230 + 0x60 * (b) + 0x4 * (1 - (c)))


#define LPD_RTI_C(a, b, c, d)	(LPD_M_BASE(a) + 0x80 + 0x100 * (b) + 0x40 * (1 - (c)) + 0x8 * (d))
#define LPD_RTI_D(a, b, c, d)	(LPD_M_BASE(a) + 0x84 + 0x100 * (b) + 0x40 * (1 - (c)) + 0x8 * (c))


#elif defined (CONFIG_MACH_MN2WS0251_REF) || defined(CONFIG_MACH_MN2WS0270_REF)
#define LPD_BASE			0x5BC01000


#define LPD_C_OFFSET		0x00200000
#define LPD_P_OFFSET		0x00000000

#define LPD_C_BASE(a)		(LPD_BASE + LPD_C_OFFSET * (a))
#define LPD_P_BASE(a, b)	(LPD_C_BASE(a)  + LPD_P_OFFSET * (b))


#define LPD_DB(a,b,c,d)		(LPD_P_BASE(a,b) + 0x1CC + 0x40*(c) + 0x4*(d))
#define LPD_DL(a,b,c,d)		(LPD_P_BASE(a,b) + 0x1E0 + 0x40*(c) + 0x4*(d))
#define LPD_DM(a,b,c)		(LPD_P_BASE(a,b) + 0x1EC + 0x40*(c))
#define LPD_DG(a,b,c)		(LPD_P_BASE(a,b) + 0x1F0 + 0x40*(c))
#endif

#endif	/* _ASM_ARCH_LPD_H */
